#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=1_chrome.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Description=d3monCorp
#AutoIt3Wrapper_Res_Fileversion=0.0.0.3
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights reserved.
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseAnsi=y
Opt('GUIOnEventMode', 1)
#include 'GUICtrlSetOnHover_UDF.au3'

Local $r_reg = RegRead('HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Uninstall\Google Chrome', 'UninstallString')
If $r_reg = "" Then Exit MsgBox(16, 'Google theme maker', 'Please install Google Chrome before running this application !')
Local $s_dll = StringTrimLeft(StringTrimRight($r_reg, 32) & 'Themes\default.dll', 1)

Local $s_dir = @TempDir & '\CTM\', $iExit_Event = -1
_FileInstall( )

#Region GUI
$GUI = GUICreate('Chrome theme maker', 375, 215, -1, -1, 0x80000000)
GUISetOnEvent(-7, '_Move')
GUISetBkColor(0xFFFFFF)

GUICtrlCreatePic($s_dir & 'CTM.bmp', 0, 0, 375, 215, 128)

$p_mn = GUICtrlCreatePic($s_dir & 'min-n.bmp', 302, 1, 26, 17)
GUICtrlSetOnHover($p_mn, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_mn, '_Min')

$p_cl = GUICtrlCreatePic($s_dir & 'close-n.bmp', 328, 1, 42, 17)
GUICtrlSetOnHover($p_cl, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_cl, '_Exit_Event')

$a_ld = GUICtrlCreateAvi($s_dir & 'load.avi', -1, 55, 45, 39, 39)

$b_et = GUICtrlCreateButton('Extract the current theme...', 40, 100, 295, 22)
GUICtrlSetOnEvent(-1, '_Extract')

$b_bt = GUICtrlCreateButton('Build a new theme...', 40, 125, 295, 22)
GUICtrlSetOnEvent(-1, '_Build')

$b_rt = GUICtrlCreateButton('Restore the default theme', 40, 180, 295, 22)
GUICtrlSetOnEvent(-1, '_Restore')

$b_ct = GUICtrlCreateButton('Change the current theme...', 40, 150, 295, 22)
GUICtrlSetOnEvent($b_ct, '_Change')

DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00080000)
GUISetState(@SW_SHOW, $GUI)
#EndRegion
;

While Sleep(250)
	If $iExit_Event = 1 Then _Exit( )
WEnd

Func _ResHack( )
	InetGet('http://delphi.icm.edu.pl/ftp/tools/ResHack.zip', $s_dir & 'ResHack.zip', 1, 1)
	While @InetGetActive
		Sleep(250)
	WEnd
	_ExtractZip($s_dir & 'ResHack.zip', @TempDir & '\CTM')
;~ 	_7ZIPExtract(0, $s_dir & 'ResHack.zip', @TempDir & '\CTM', 1)
EndFunc

Func _Build( )
	$f_sf = FileSelectFolder('Select customized theme pictures folder', "", 7, @ScriptDir, $GUI)
	If @error Then Return MsgBox(48, 'Chrome theme maker', 'Please select a folder !')

	GUICtrlSetState($b_bt, 128)
	If Not FileExists($s_dir & 'ResHacker.exe') Then
		GUICtrlSetData($b_bt, 'Downloading Reshacker...')
		_ResHack( )
	EndIf

	$f_ff = FileFindFirstFile($f_sf & '\*.png')
	If $f_ff = -1 Then
		GUICtrlSetState($b_bt, 64)
		GUICtrlSetData($b_bt, 'Build a new theme...')
		Return MsgBox(48, 'Chrome theme maker', 'Please select a valid theme folder !')
	EndIf

	GUICtrlSetData($b_bt, 'Building customized theme...')
	GUICtrlSetState($a_ld, 1)

	While 1
		$f_nf = FileFindNextFile($f_ff)
		If @error Then ExitLoop
		FileCopy($f_sf & '\' & $f_nf, $s_dir, 1)
	WEnd

	FileCopy($s_dll, $s_dir & 'default.dll_bak', 1)
	ShellExecuteWait($s_dir & 'ResHacker.exe', '-script build.script', $s_dir)
	GUICtrlSetData($b_bt, 'Customized theme built !')
	GUICtrlSetState($a_ld, 0)

	$f_msg = MsgBox(65, 'Chrome theme maker', 'Customized theme built !' _
	& @CRLF & 'Press OK to replace the current theme with this one' _
	& @CRLF & 'Otherwise press Cancel to select the destination theme')

	If $f_msg = 1 Then
		$f_mv = FileMove($s_dll, $s_dll & '_bak', 1)
		If $f_mv = 1 Then
			FileMove($s_dir & '\default.dll', $s_dll)
			MsgBox(64, 'Chrome theme maker', 'Customized theme is now the default one, enjoy !')
		Else
			MsgBox(48, 'Chrome theme maker', 'Please close any instance of Google Chrome !')
		EndIf
	ElseIf $f_msg = 2 Then
		$f_sd = FileSaveDialog('Select a destination to save the custom theme', "", 'theme (*.dll)', 3, 'default.dll', $GUI)
		If @error Then MsgBox(48, 'Chrome theme maker', 'Could not save customized theme !')
		FileMove($s_dir & 'default.dll', $f_sd, 1)
		MsgBox(64, 'Chrome theme maker', 'Customized theme saved !')
	EndIf

	GUICtrlSetState($b_bt, 64)
	GUICtrlSetData($b_bt, 'Build a new theme...')
EndFunc

Func _Extract( )
	$f_sf = FileSelectFolder('Select folder to extract default theme pictures', "", 7, @ScriptDir, $GUI)
	If @error Then Return MsgBox(48, 'Chrome theme maker', 'Please select a folder !')

	GUICtrlSetState($b_et, 128)
	If Not FileExists($s_dir & 'ResHacker.exe') Then
		GUICtrlSetData($b_et, 'Downloading Reshacker...')
		_ResHack( )
	EndIf

	GUICtrlSetData($b_et, 'Extracting default theme...')
	GUICtrlSetState($a_ld, 1)

	FileCopy($s_dll, @TempDir & '\CTM\default.dll', 1)
	ShellExecuteWait($s_dir & 'ResHacker.exe', '-extract default.dll,default.rc,,,', $s_dir)

	$f_ff = FileFindFirstFile($s_dir & '*.bin')
	While 1
		$f_nf = FileFindNextFile($f_ff)
		If @error Then ExitLoop
		FileMove($s_dir & '' & $f_nf, $f_sf & '\' & StringTrimRight($f_nf, 4) & '.png', 1)
	WEnd
	ShellExecute($f_sf)

	GUICtrlSetState($b_et, 64)
	GUICtrlSetData($b_et, 'Extract the current theme...')
	GUICtrlSetState($a_ld, 0)
EndFunc

Func _Restore( )
	If Not FileExists($s_dll & '_bak') Then Return MsgBox(48, 'Chrome theme maker', 'Backup theme file not found !')

	$f_mv = FileMove($s_dll & '_bak', $s_dll, 1)
	If $f_mv = 1 Then
		MsgBox(64, 'Chrome theme maker', 'Original theme restored !')
	Else
		MsgBox(48, 'Chrome theme maker', 'Please close any instance of Google Chrome !')
	EndIf
EndFunc

Func _Change( )
	$f_od = FileOpenDialog('Select a theme to replace with the current one', @ScriptDir, 'theme (*.dll)', 3, 'default.dll', $GUI)
	If @error Then Return MsgBox(48, 'Chrome theme maker', 'Please select a valid theme !')

	$f_mv = FileMove($s_dll, $s_dll & '_bak', 1)
	FileCopy($f_od, $s_dll, 1)
	If $f_mv = 1 Then
		MsgBox(64, 'Chrome theme maker', 'Chrome theme has been changed !')
	Else
		MsgBox(48, 'Chrome theme maker', 'Please close any instance of Google Chrome !')
	EndIf
EndFunc

Func _FileInstall( )
	DirCreate(@TempDir & '\CTM')
	FileInstall('build.script', $s_dir & 'build.script')

	FileInstall('CTM.bmp', $s_dir & 'CTM.bmp')
	FileInstall('load.avi', $s_dir & 'load.avi')
	FileInstall('close-h.bmp', $s_dir & 'close-h.bmp')
	FileInstall('close-n.bmp', $s_dir & 'close-n.bmp')
	FileInstall('close-p.bmp', $s_dir & 'close-p.bmp')
	FileInstall('min-n.bmp', $s_dir & 'min-n.bmp')
	FileInstall('min-h.bmp', $s_dir & 'min-h.bmp')
	FileInstall('min-p.bmp', $s_dir & 'min-p.bmp')
EndFunc

Func _Exit_Event( )
    $iExit_Event = 1
EndFunc

Func _Exit( )
    GUICtrlSetImage($p_cl, 'close-p.bmp')

    While _IsPressed('01')
        Sleep(10)
    WEnd

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If UBound($aCur_Info) > 4 And $aCur_Info[4] = $p_cl Then
		DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00090000)
		Exit DirRemove($s_dir, 1)
    EndIf

    $iExit_Event = -1
EndFunc

Func _Min( )
    GUICtrlSetImage($p_mn, 'min-p.bmp')

    While _IsPressed('01')
        Sleep(10)
    WEnd

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If UBound($aCur_Info) > 4 And $aCur_Info[4] = $p_mn Then GUISetState(@SW_MINIMIZE)
EndFunc

Func _Move( )
    $f_mgp = MouseGetPos( )
    $f_wgp = WinGetPos($GUI)

    If $f_mgp[1] > $f_wgp[1] + 40 Then Return ;Nothing

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If UBound($aCur_Info) > 4 And ($aCur_Info[4] = $p_cl Or $aCur_Info[4] = $p_mn) Then Return ;No need to drag by button

    DllCall('user32.dll', 'int', 'SendMessage', 'hWnd', $GUI, 'int', 0x00A1, 'int', 2, 'int', 0)
EndFunc

Func _Hover($iCtrl)
	Switch $iCtrl
		Case $p_mn
			GUICtrlSetImage($p_mn, 'min-h.bmp')
		Case $p_cl
			GUICtrlSetImage($p_cl, 'close-h.bmp')
	EndSwitch
EndFunc

Func _NoHover($iCtrl)
	Switch $iCtrl
		Case $p_mn
			GUICtrlSetImage($p_mn, 'min-n.bmp')
		Case $p_cl
			GUICtrlSetImage($p_cl, 'close-n.bmp')
	EndSwitch
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _ExtractZip
; Author ........: Trancexx, corgano
; ===============================================================================================================================
Func _ExtractZip($sZipFile, $sDestinationFolder, $sFolderStructure = "")
    Local $i
    Do
        $i += 1
        $sTempZipFolder = @TempDir & "\tmp " & $i & " for " & StringRegExpReplace($sZipFile, ".*\\", "")
    Until Not FileExists($sTempZipFolder) ; this folder will be created during extraction

    Local $oShell = ObjCreate("Shell.Application")

    If Not IsObj($oShell) Then
        Return SetError(1, 0, 0) ; highly unlikely but could happen
    EndIf

    Local $oDestinationFolder = $oShell.NameSpace($sDestinationFolder)
    If Not IsObj($oDestinationFolder) Then
        DirCreate($sDestinationFolder)
;~      Return SetError(2, 0, 0) ; unavailable destionation location
    EndIf

    Local $oOriginFolder = $oShell.NameSpace($sZipFile & "\" & $sFolderStructure) ; FolderStructure is overstatement because of the available depth
    If Not IsObj($oOriginFolder) Then
        Return SetError(3, 0, 0) ; unavailable location
    EndIf

    Local $oOriginFile = $oOriginFolder.Items();get all items
    If Not IsObj($oOriginFile) Then
        Return SetError(4, 0, 0) ; no such file in ZIP file
    EndIf

    ; copy content of origin to destination
    $oDestinationFolder.CopyHere($oOriginFile, 20) ; 20 means 4 and 16, replaces files if asked
    DirRemove($sTempZipFolder, 1) ; clean temp dir

    Return 1
EndFunc


; #FUNCTION# ====================================================================================================================
; Name...........: _IsPressed
; Author ........: ezzetabi and Jon
; ===============================================================================================================================
Func _IsPressed($sHexKey, $vDLL = 'user32.dll')
	Local $a_R = DllCall($vDLL, "int", "GetAsyncKeyState", "int", '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed
